----
CREATE OR REPLACE FUNCTION tsystem.syncro__dbupdates(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO dbupdates ( upd_id,
                            upd_parent,
                            upd_minver,
                            upd_kunde,
                            --  upd_donedat,
                            upd_bez,
                            upd_txt,
                            upd_sql,
                            upd_projekt,
                            upd_noerr,
                            upd_sperr,
                            --,
                            dbrid,
                            insert_date,
                            insert_by,
                            modified_by,
                            modified_date
                          )

    SELECT *
      FROM dblink(_dblink,
                   'SELECT upd_id,
                           upd_parent,
                           upd_minver,
                           upd_kunde,
                           -- upd_donedat,
                           upd_bez,
                           upd_txt,
                           upd_sql,
                           upd_projekt,
                           upd_noerr,
                           upd_sperr,
                           --,
                           dbrid,
                           insert_date,
                           insert_by,
                           modified_by,
                           modified_date
                      FROM dbupdates
                     WHERE
                              upd_kunde IS null
                          AND upd_minver <= ' || TSystem.quote_literal__connstr_param( TSystem.Settings__Get( 'ProdatVersion' ) ) || '
                  ')
        AS ( upd_id_       varchar(30),
             upd_parent    varchar(30),              -- parent (Baumstruktur)
             upd_minver    varchar(11),              -- [SYNCRO:Version] Mindest-Programmversion
             upd_kunde     varchar(20),              -- [SYNCRO:Kunde]
             -- upd_donedat   timestamp(0),             -- [SYNCRO:NotThisFields] update eingespielt am
             upd_bez       varchar(150),
             upd_txt       text,
             upd_sql       text,
             upd_projekt   varchar(100),
             upd_noerr     boolean,
             upd_sperr     boolean,
             -- System (tables__generate_missing_fields)
             dbrid         varchar(32),
             insert_date   date,
             insert_by     varchar(32),
             modified_by   varchar(32),
             modified_date timestamp(0)               -- [SYNCRO:Modified]
           )
       WHERE NOT EXISTS( SELECT true FROM dbupdates WHERE upd_id = upd_id_ );
    ---

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__text0(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO text0 ( t_nr, t_feld0, t_feld0_modified,
                        t_feld1, t_feld1_modified,
                        t_feld2, t_feld2_modified,
                        t_feld3, t_feld3_modified,
                        t_feld4, t_feld4_modified,
                        t_feld5, t_feld5_modified,
                        t_feld6, t_feld6_modified,
                        t_feld7, t_feld7_modified,
                        t_feld8, t_feld8_modified,
                        t_modified
                )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT t_nr, t_feld0, t_feld0_modified,
                           t_feld1, t_feld1_modified,
                           t_feld2, t_feld2_modified,
                           t_feld3, t_feld3_modified,
                           t_feld4, t_feld4_modified,
                           t_feld5, t_feld5_modified,
                           t_feld6, t_feld6_modified,
                           t_feld7, t_feld7_modified,
                           t_feld8, t_feld8_modified,
                           t_modified
                  FROM text0
              ')
        AS ( t_nr_ int, t_feld0 text, t_feld0_modified timestamp(0),
                   t_feld1 text, t_feld1_modified timestamp(0),
                   t_feld2 text, t_feld2_modified timestamp(0),
                   t_feld3 text, t_feld3_modified timestamp(0),
                   t_feld4 text, t_feld4_modified timestamp(0),
                   t_feld5 text, t_feld5_modified timestamp(0),
                   t_feld6 text, t_feld6_modified timestamp(0),
                   t_feld7 text, t_feld7_modified timestamp(0),
                   t_feld8 text, t_feld8_modified timestamp(0),
                   t_modified timestamp(0)
       )
     WHERE NOT EXISTS( SELECT true FROM text0 WHERE t_nr = t_nr_ );
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__runtimeforms(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO runtimeforms (
                              rtf_id,
                              rtf_stamp,
                              rtf_modified,
                              rtf_table,
                              rtf_txtnr,
                              rtf_shorthlptxtnr,
                              rtf_text,
                              rtf_textdfm,
                              rtf_script,
                              rtf_blanksql,
                              rtf_changetext,
                              rtf_runtimeform,
                              rtf_localmodified
                            )

    SELECT *
      FROM dblink(_dblink,
               'SELECT rtf_id,
                       rtf_stamp,
                       rtf_modified,
                       rtf_table,
                       rtf_txtnr,
                       rtf_shorthlptxtnr,
                       rtf_text,
                       rtf_textdfm,
                       rtf_script,
                       rtf_blanksql,
                       rtf_changetext,
                       rtf_runtimeform,
                       rtf_localmodified
                  FROM runtimeforms
              ')
    AS (
        rtf_id_               INTEGER,   -- PRIMARY KEY,                               -- interne statische ID [rtf_stamp statt rtf_id als SyncID hilft doppelt belegte IDs zu bemerken, da sie sich nicht hochladen lassen]
        rtf_stamp             TIMESTAMP, -- (0) UNIQUE NOT NULL DEFAULT currenttime(), -- [SYNCRO:SyncID]
        rtf_modified          TIMESTAMP, -- (0),                                       -- [SYNCRO:Modified]
        rtf_table             VARCHAR,   -- (30),                                      -- [SYNCRO:Deleted='DELETED']
        rtf_txtnr             INTEGER,
        rtf_shorthlptxtnr     INTEGER,
        rtf_text              TEXT,
        rtf_textdfm           TEXT,
        rtf_script            TEXT,
        rtf_blanksql          BOOL,
        rtf_changetext        TEXT,
        rtf_runtimeform       BOOL,      -- DEFAULT FALSE,
        rtf_localmodified     BOOL       -- DEFAULT FALSE                              -- [SYNCRO:NotThisFields]
       )
     WHERE NOT EXISTS( SELECT true FROM runtimeforms WHERE rtf_id = rtf_id_ );
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__f2standard(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO f2standard ( f2s_stamp,
                             f2s_name,
                             f2s_modified,
                             f2s_table,
                             f2s_StandardSuche,
                             f2s_regConfig,
                             f2s_query,
                             f2s_querysub,
                             f2s_deleted,
                             wherescript,
                             f2s_drstype
                           )

    SELECT *
      FROM dblink(_dblink,
               'SELECT f2s_stamp,
                       f2s_name,
                       f2s_modified,
                       f2s_table,
                       f2s_StandardSuche,
                       f2s_regConfig,
                       f2s_query,
                       f2s_querysub,
                       f2s_deleted,
                       wherescript,
                       f2s_drstype
                  FROM f2standard
              ')
        AS (
             f2s_stamp_            TIMESTAMP, --(0) UNIQUE NOT NULL DEFAULT currenttime(), -- [SYNCRO:SyncID]
             f2s_name              INTEGER, -- NOT NULL PRIMARY KEY,                       -- TEXT NR
             f2s_modified          TIMESTAMP, --(0),                                       -- [SYNCRO:Modified]
             f2s_table             VARCHAR, --(50),
             f2s_StandardSuche     BOOLEAN, -- DEFAULT false,
             f2s_regConfig         TEXT, --,
             f2s_query             TEXT, --,
             f2s_querysub          TEXT, --,
             f2s_deleted           BOOLEAN, -- NOT NULL DEFAULT false,
             wherescript           INTEGER, -- REFERENCES runtimeforms ON UPDATE CASCADE,  -- [SYNCRO:TranslateToLocal]
             f2s_drstype           VARCHAR --(100)                                         -- drs_type aus DataRowState (#5617)
           )
       WHERE NOT EXISTS( SELECT true FROM f2standard WHERE f2s_stamp = f2s_stamp_ );
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__f2poss__f2rck(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    TRUNCATE f2poss CASCADE; -- Truncate, da delete nur delete flag setzt wenn nicht syncro

    -- hinweis: f2_id beibehalten, da sonst f2rck so einfach nicht geht.
    INSERT INTO f2poss (
                         f2_id, --                 SERIAL PRIMARY KEY,                                   -- [SYNCRO:NotThisFields]
                         f2_stamp, --              TIMESTAMP(0) UNIQUE NOT NULL DEFAULT currenttime(),   -- [SYNCRO:SyncID]
                         f2_loadall, --            BOOLEAN DEFAULT false,
                         f2_standard, --           INTEGER CONSTRAINT f2poss_f2standard REFERENCES f2standard ON DELETE RESTRICT ON UPDATE CASCADE,  -- f2standard.f2s_name = text0
                         f2_query, --              TEXT,
                         f2_querysub, --           TEXT,                                                 -- subquery, zB Arbeitsgänge zur AVOR
                         --, -- f2_customize          TEXT,                                              -- alt
                         --, -- f2_uniquekey          VARCHAR,                                           -- alt
                         feldname, --              VARCHAR,
                         modulname, --             VARCHAR,
                         vartxtnr, --              INTEGER,                                              -- TEXT NR
                         pos, --                   SMALLINT,
                         f2_filter, --             VARCHAR,
                         runtimeforms, --          INTEGER REFERENCES runtimeforms ON UPDATE CASCADE,    -- [SYNCRO:TranslateToLocal]
                         fastf2, --                BOOL DEFAULT false,
                         f2_previewfield, --       VARCHAR(50),
                         f2_kunde, --              VARCHAR(50),                                          -- [SYNCRO:Kunde] [SYNCRO ALT:Deleted='DELETED']
                         f2_modified, --           TIMESTAMP(0)  DEFAULT currenttime(),                  -- [SYNCRO:Modified]
                         --syncpcsftp, --          BOOLEAN,                                              -- Alt
                         f2_deactrtf, --           BOOLEAN,
                         f2_simple, --             BOOLEAN,
                         f2_dropdownmodules, --    TEXT,                                                 -- Verlinkung zu Modulen
                         f2_deleted, --            BOOLEAN DEFAULT false,                                -- [SYNCRO:Deleted]
                         --f2_localmodified, --      BOOLEAN DEFAULT false,                                -- [SYNCRO:NotThisFields]
                         f2_changetext, --         TEXT,                                                 -- Änderungshinweise
                         f2_searchedit, --         VARCHAR,                                              -- Aus diesem Editfeld soll das :SearchEd gefuellt werden
                         f2_autosearch, --         BOOLEAN DEFAULT false,                                -- Nach dem SearchEd fuellen automatisch suchen oder Nutzerinteraktion abwarten?
                         f2_standardadresss, --    BOOLEAN NOT NULL DEFAULT false,
                         f2_groupname, --          VARCHAR(100),                                         -- gruppe: lag, rechnung, etc => FieldAlias
                         f2_config, --             TEXT,
                         f2_drstype --            VARCHAR(100)                                           -- drs_type aus DataRowState (#5617)
                       )
    SELECT *
      FROM dblink(_dblink,
               'SELECT f2_id,
                       f2_stamp,
                       f2_loadall,
                       f2_standard,
                       f2_query,
                       f2_querysub,
                       --,
                       --,
                       feldname,
                       modulname,
                       vartxtnr,
                       pos,
                       f2_filter,
                       runtimeforms,
                       fastf2,
                       f2_previewfield,
                       f2_kunde,
                       f2_modified,
                       --syncpcsftp,
                       f2_deactrtf,
                       f2_simple,
                       f2_dropdownmodules,
                       f2_deleted,
                       --f2_localmodified,
                       f2_changetext,
                       f2_searchedit,
                       f2_autosearch,
                       f2_standardadresss,
                       f2_groupname,
                       f2_config,
                       f2_drstype
                  FROM f2poss
              ')
        AS (
              f2_id_                integer, -- PRIMARY KEY,                                   -- [SYNCRO:NotThisFields]
              f2_stamp              timestamp, --(0) UNIQUE NOT NULL DEFAULT currenttime(),   -- [SYNCRO:SyncID]
              f2_loadall            boolean, -- DEFAULT false,
              f2_standard           integer, -- CONSTRAINT f2poss_f2standard REFERENCES f2standard ON DELETE RESTRICT ON UPDATE CASCADE,  -- f2standard.f2s_name = text0
              f2_query              text,
              f2_querysub           text,                                                 -- subquery, zB Arbeitsgänge zur AVOR
              -- f2_customize          text,                                              -- alt
              -- f2_uniquekey          VARCHAR,                                           -- alt
              feldname              varchar,
              modulname             varchar,
              vartxtnr              integer,                                              -- text NR
              pos                   smallint,
              f2_filter             varchar,
              runtimeforms          integer, -- REFERENCES runtimeforms ON UPDATE CASCADE,    -- [SYNCRO:TranslateToLocal]
              fastf2                boolean, -- DEFAULT false,
              f2_previewfield       varchar(50),
              f2_kunde              varchar(50),                                          -- [SYNCRO:Kunde] [SYNCRO ALT:Deleted='DELETED']
              f2_modified           timestamp(0), --  DEFAULT currenttime(),                  -- [SYNCRO:Modified]
              --syncpcsftp          boolean,                                              -- Alt
              f2_deactrtf           boolean,
              f2_simple             boolean,
              f2_dropdownmodules    text,                                                 -- Verlinkung zu Modulen
              f2_deleted            boolean, -- DEFAULT false,                                -- [SYNCRO:Deleted]
              -- f2_localmodified      boolean, -- DEFAULT false,                                -- [SYNCRO:NotThisFields]
              f2_changetext         text,                                                 -- Änderungshinweise
              f2_searchedit         varchar,                                              -- Aus diesem Editfeld soll das :SearchEd gefuellt werden
              f2_autosearch         boolean, -- DEFAULT false,                                -- Nach dem SearchEd fuellen automatisch suchen oder Nutzerinteraktion abwarten?
              f2_standardadresss    boolean, -- NOT NULL DEFAULT false,
              f2_groupname          varchar(100),                                         -- gruppe: lag, rechnung, etc => FieldAlias
              f2_config             text,
              f2_drstype            varchar(100)                                           -- drs_type aus DataRowState (#5617)
             );

    -- SELECT setval('f2poss_f2_id_seq', max(f2_id) ) FROM f2poss;
    PERFORM setval('f2poss_f2_id_seq', max(f2_id) ) FROM f2poss;

    INSERT INTO f2rck (-- f2r_id, --                SERIAL PRIMARY KEY,  -- [SYNCRO:NotThisFields]
                        f2r_f2_id, --             INTEGER CONSTRAINT f2rck_f2poss REFERENCES f2poss ON UPDATE CASCADE ON DELETE CASCADE,  -- [SYNCRO:TranslateToLocal]
                        f2r_pos, --               INTEGER,      -- Reihenfolge der Abarbeitung
                        f2r_f2rckfieldn, --       VARCHAR(25),  -- Quellfeld im F2
                        f2r_forcomponent, --      VARCHAR(50),  -- Zielkomponente ("Name", "Self", "Self.Name", "Name.SubName")
                        f2r_forfield --          VARCHAR(50)   -- Zielfeld im TDataSet/TCimQuery2/TCimClass/TServSql ("FieldName")
                                                        -- ODER Methode der Zielkomponente ausführen ("Methode()" > f2r_f2rckfieldn wird nicht benötigt)
                      )
    SELECT *
      FROM dblink(_dblink,
               'SELECT --
                       f2r_f2_id,
                       f2r_pos,
                       f2r_f2rckfieldn,
                       f2r_forcomponent,
                       f2r_forfield
                  FROM f2rck
               ')
        AS (--f2r_id                serial, -- PRIMARY K
             f2r_f2_id             integer, -- CONSTRAINT f
             f2r_pos               integer,
             f2r_f2rckfieldn       varchar(25),
             f2r_forcomponent      varchar(50),
             f2r_forfield          varchar(50)
           );

    --SELECT setval('f2rck_f2r_id_seq', max(f2r_id) ) FROM f2rck;
    PERFORM setval('f2rck_f2r_id_seq', max(f2r_id) ) FROM f2rck;

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__fieldalias(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO fieldalias ( fa_modified, --           timestamp(0),
                             fa_fieldname, --          varchar(40)
                             fa_tablename, --          varchar(40),
                             fa_textno, --             integer,
                             fa_hint, --               text,
                             fa_linkmodules, --        text,
                             --fa_bi_displayformat, -- varchar(20),
                             fa_displayformat, --      varchar(20),
                             fa_editformat, --         varchar(20),
                             fa_imageindex, --         integer,
                             fa_constraints, --        varchar(100)
                             fa_wawipos_map --        varchar(40)
                          )
    SELECT *
      FROM dblink(_dblink,
               'SELECT fa_modified,
                       fa_fieldname,
                       fa_tablename,
                       fa_textno,
                       fa_hint,
                       fa_linkmodules,
                       --fa_bi_displayformat,
                       fa_displayformat,
                       fa_editformat,
                       fa_imageindex,
                       fa_constraints,
                       fa_wawipos_map
                  FROM fieldalias
              ')
        AS (
            fa_modified_          timestamp(0),
            fa_fieldname          varchar(63),
            fa_tablename          varchar(63),
            fa_textno             integer,
            fa_hint               text,
            fa_linkmodules        text,
            --fa_bi_displayformat varchar(20),
            fa_displayformat      varchar(20),
            fa_editformat         varchar(20),
            fa_imageindex         integer,
            fa_constraints        varchar(100),
            fa_wawipos_map        varchar(63)
            )
      WHERE NOT EXISTS( SELECT true FROM fieldalias WHERE fa_modified = fa_modified_ );

  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__itemlist(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO itemlist ( il_id,
                           il_type,
                           il_group,
                           il_item
                         )
    SELECT *
      FROM dblink(_dblink,
               'SELECT il_id,
                       il_type,
                       il_group,
                       il_item
                  FROM itemlist
                ')
        AS (
            il_id             INTEGER,
            il_type           VARCHAR,
            il_group          VARCHAR,
            il_item           VARCHAR
           );

    --SELECT setval('itemlist_il_id_seq', max(il_id) ) FROM itemlist;
    PERFORM setval('itemlist_il_id_seq', max(il_id) ) FROM itemlist;
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__gridfilter(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO gridfilter ( gf_id,
                             gf_item,
                             gf_minr,
                             gf_description,
                             gf_filter,
                             gf_filterhint,
                             gf_default,
                             gf_sync,
                             gf_deleted,
                             insert_date,
                             insert_by,
                             modified_date,
                             modified_by
                          )
    SELECT *
      FROM dblink(_dblink,
               'SELECT gf_id,
                       gf_item,
                       gf_minr,
                       gf_description,
                       gf_filter,
                       gf_filterhint,
                       gf_default,
                       gf_sync,
                       gf_deleted,
                       insert_date,
                       insert_by,
                       modified_date,
                       modified_by
                  FROM gridfilter
              ')
        AS (
            gf_id             TIMESTAMP,
            gf_item           INTEGER,
            gf_minr           INTEGER,
            gf_description    VARCHAR,
            gf_filter         BYTEA,
            gf_filterhint     VARCHAR,
            gf_default        BOOLEAN,
            gf_sync           BOOLEAN,
            gf_deleted        BOOLEAN,
            insert_date       DATE,
            insert_by         VARCHAR,
            modified_date     timestamp(0),
            modified_by       VARCHAR
           );
  END $$ LANGUAGE plpgsql;

--- neue Funktionen
CREATE OR REPLACE FUNCTION tsystem.syncro__mainmenu(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO mainmenu ( mm_id,
                           mm_stamp,
                           mm_modified,
                           mm_description,
                           mm_textNo,
                           mm_parent,
                           mm_posi,
                           mm_action,
                           mm_library,
                           mm_proc,
                           mm_shorthlptxtnr,
                           mm_picture,
                           mm_inheritedrights,
                           mm_hide,
                           mm_bde,
                           mm_system,
                           mm_checkrights,
                           mm_formclassname,
                           mm_sql,
                           mm_macro,
                           mm_config,
                           mm_kunde,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
                         )
    SELECT                 mm_id,
                           mm_stamp,
                           mm_modified,
                           mm_description,
                           mm_textNo,
                           mm_parent,
                           mm_posi,
                           mm_action,
                           mm_library,
                           mm_proc,
                           mm_shorthlptxtnr,
                           lo_from_bytea( 0, mm_picture ) AS mm_picture,   --- bytea -> lo
                           mm_inheritedrights,
                           mm_hide,
                           mm_bde,
                           mm_system,
                           mm_checkrights,
                           mm_formclassname,
                           mm_sql,
                           mm_macro,
                           mm_config,
                           mm_kunde,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
      FROM dblink( _dblink,
                   'SELECT mm_id,
                           mm_stamp,
                           mm_modified,
                           mm_description,
                           mm_textNo,
                           mm_parent,
                           mm_posi,
                           mm_action,
                           mm_library,
                           mm_proc,
                           mm_shorthlptxtnr,
                           lo_get( mm_picture ) AS mm_picture,   --- lo -> bytea
                           mm_inheritedrights,
                           mm_hide,
                           mm_bde,
                           mm_system,
                           mm_checkrights,
                           mm_formclassname,
                           mm_sql,
                           mm_macro,
                           mm_config,
                           mm_kunde,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
                      FROM mainmenu
                  ')
        AS ( mm_id                 integer,
             mm_stamp              timestamp(0), --- UNIQUE NOT NULL DEFAULT currenttime(),  -- [SYNCRO:SyncID]
             mm_modified           timestamp(0),                                             -- [SYNCRO:Modified]
             mm_description        varchar(50),
             mm_textNo             integer,
             mm_parent             integer,
             mm_posi               smallint,
             mm_action             smallint,
             mm_library            varchar(50),
             mm_proc               varchar(50),
             mm_shorthlptxtnr      integer,
             mm_picture            bytea,
             mm_inheritedrights    boolean, --- DEFAULT TRUE,                                -- [SYNCRO:NotThisFields]
             mm_hide               boolean, --- DEFAULT FALSE,
             mm_bde                boolean, --- DEFAULT FALSE,
             mm_system             boolean, --- DEFAULT FALSE,
             mm_checkrights        boolean, --- NOT NULL DEFAULT FALSE,                      -- [SYNCRO:NotThisFields]
             mm_formclassname      varchar(75),
             mm_sql                text,
             mm_macro              text,
             mm_config             text,
             mm_kunde              varchar(20),                                          -- [SYNCRO:Deleted='DELETED']
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__sondfunc(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO sondfunc ( sf_id,
                           sf_stamp,
                           sf_modified,
                           sf_sqltable,
                           sf_formclass,
                           sf_nr,
                           sf_imageIndex,
                           sf_rtf,
                           sf_txtnr,
                           sf_hinttxtnr,
                           sf_cond,
                           sf_emptyallowed,
                           sf_SQL,
                           sf_menuButton,
                           sf_config,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      sf_id,
                      sf_stamp,
                      sf_modified,
                      sf_sqltable,
                      sf_formclass,
                      sf_nr,
                      sf_imageIndex,
                      sf_rtf,
                      sf_txtnr,
                      sf_hinttxtnr,
                      sf_cond,
                      sf_emptyallowed,
                      sf_SQL,
                      sf_menuButton,
                      sf_config,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM sondfunc
                  ')
        AS (
             sf_id                 integer,
             sf_stamp              timestamp(0), --- NOT NULL UNIQUE DEFAULT currenttime(),  -- [SYNCRO:SyncID]
             sf_modified           timestamp(0),                                        -- [SYNCRO:Modified]
             sf_sqltable           varchar(50),
             sf_formclass          varchar(75),
             sf_nr                 integer,
             sf_imageIndex         integer,
             sf_rtf                integer, ---  REFERENCES runtimeforms ON UPDATE CASCADE,
             sf_txtnr              integer,
             sf_hinttxtnr          integer,
             sf_cond               text,
             sf_emptyallowed       boolean, ---   DEFAULT False,
             sf_SQL                text,
             sf_menuButton         boolean, ---   DEFAULT false,
             sf_config             text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );

    ---
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__picndoku(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO picndoku (
                           pd_id,
                           pd_tablename,
                           pd_dbrid,
                           pd_dokident,
                           pd_doktype,
                           pd_parentnodeident,
                           pd_path,
                           pd_path_user,
                           pd_dokumentfile,
                           pd_blob,
                           pd_txt,
                           pd_print,
                           pd_source,
                           pd_date,
                           pd_stamp,
                           pd_modified,
                           pd_archive,
                           pd_revision_id,
                           pd_deletable,
                           pd_dmsremotefiledoktype,
                           pd_dmsremotearchiv,
                           pd_dmsremotefile,
                           pd_dmshash,
                           pd_dms_delayed_upload,
                           pd_dmscomment,
                           pd_external_dms_id,
                           pd_external_dms_updated,
                           pd_external_dms_changed,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
                    )
    SELECT            pd_id,
                      pd_tablename,
                      pd_dbrid,
                      pd_dokident,
                      pd_doktype,
                      pd_parentnodeident,
                      pd_path,
                      pd_path_user,
                      pd_dokumentfile,
                      lo_from_bytea( 0, pd_blob ) AS pd_blob,   --- lo -> bytea
                      pd_txt,
                      pd_print,
                      pd_source,
                      pd_date,
                      pd_stamp,
                      pd_modified,
                      pd_archive,
                      pd_revision_id,
                      pd_deletable,
                      pd_dmsremotefiledoktype,
                      pd_dmsremotearchiv,
                      pd_dmsremotefile,
                      pd_dmshash,
                      pd_dms_delayed_upload,
                      pd_dmscomment,
                      pd_external_dms_id,
                      pd_external_dms_updated,
                      pd_external_dms_changed,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
      FROM dblink(_dblink,
                   'SELECT
                      pd_id,
                      pd_tablename,
                      pd_dbrid,
                      pd_dokident,
                      pd_doktype,
                      pd_parentnodeident,
                      pd_path,
                      pd_path_user,
                      pd_dokumentfile,
                      lo_get( pd_blob ) AS pd_blob,   --- lo -> bytea
                      pd_txt,
                      pd_print,
                      pd_source,
                      pd_date,
                      pd_stamp,
                      pd_modified,
                      pd_archive,
                      pd_revision_id,
                      pd_deletable,
                      pd_dmsremotefiledoktype,
                      pd_dmsremotearchiv,
                      pd_dmsremotefile,
                      pd_dmshash,
                      pd_dms_delayed_upload,
                      pd_dmscomment,
                      pd_external_dms_id,
                      pd_external_dms_updated,
                      pd_external_dms_changed,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM picndoku
                  ')
        AS (
             pd_id                         integer,
             pd_tablename                  varchar(30),
             pd_dbrid                      varchar(32),
             pd_dokident                   varchar(100),
             pd_doktype                    varchar(30),
             pd_parentnodeident            varchar(20),
             pd_path                       varchar(500),
             pd_path_user                  varchar(100),
             pd_dokumentfile               varchar(750),
             pd_blob                       bytea,
             pd_txt                        text,
             pd_print                      boolean,
             pd_source                     varchar(10),
             pd_date                       date,
             pd_stamp                      timestamp(0),
             pd_modified                   timestamp(0),
             pd_archive                    boolean,
             pd_revision_id                integer,
             pd_deletable                  boolean,
             pd_dmsremotefiledoktype       varchar(50),
             pd_dmsremotearchiv            varchar(21),
             pd_dmsremotefile              varchar(250),
             pd_dmshash                    varchar,
             pd_dms_delayed_upload         boolean,
             pd_dmscomment                 boolean,
             pd_external_dms_id            varchar(40),
             pd_external_dms_updated       timestamp(0),
             pd_external_dms_changed       varchar(50),
             insert_date                   date,
             insert_by                     varchar(32),
             modified_date                 timestamp(0),
             modified_by                   varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__dokutypes(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO dokutypes (
                            dt_id,
                            dt_modified,
                            dt_descr,
                            dt_abteilung,
                            dt_linkto,
                            dt_dokident,
                            dt_linkforms,
                            dt_treeparentid,
                            dt_txtnr,
                            dt_dbridsql,
                            dt_forcekeyword,
                            dt_parentnodeid,
                            dt_sync,
                            dt_relateddokkeyword,
                            dt_config,
                            dt_auto_revision,
                            dt_auto_rev_period,
                            dt_da_name,
                            dt_da_name_archive,
                            dt_write_once,
                            dt_archive_default,
                            dt_archive_hideold,
                            dt_autoexportpath,
                            dt_external_dms_dokutype,
                            dt_display_limit,
                            dt_parentnodeid_default,
                            insert_date,
                            insert_by,
                            modified_date,
                            modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      dt_id,
                      dt_modified,
                      dt_descr,
                      dt_abteilung,
                      dt_linkto,
                      dt_dokident,
                      dt_linkforms,
                      dt_treeparentid,
                      dt_txtnr,
                      dt_dbridsql,
                      dt_forcekeyword,
                      dt_parentnodeid,
                      dt_sync,
                      dt_relateddokkeyword,
                      dt_config,
                      dt_auto_revision,
                      dt_auto_rev_period,
                      dt_da_name,
                      dt_da_name_archive,
                      dt_write_once,
                      dt_archive_default,
                      dt_archive_hideold,
                      dt_autoexportpath,
                      dt_external_dms_dokutype,
                      dt_display_limit,
                      dt_parentnodeid_default,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM dokutypes
                  ')
        AS (
       dt_id                    varchar(30),
             dt_modified              timestamp(0),
             dt_descr                 varchar(100),
             dt_abteilung             varchar(50),
             dt_linkto                varchar(30),
             dt_dokident              varchar(30),
             dt_linkforms             varchar(50),
             dt_treeparentid          integer,
             dt_txtnr                 integer,
             dt_dbridsql              text,
             dt_forcekeyword          text,
             dt_parentnodeid          varchar(10),
             dt_sync                  boolean,
             dt_relateddokkeyword     varchar(40),
             dt_config                text,
             dt_auto_revision         boolean,
             dt_auto_rev_period       integer,
             dt_da_name               varchar(21),
             dt_da_name_archive       varchar(21),
             dt_write_once            boolean,
             dt_archive_default       boolean,
             dt_archive_hideold       boolean,
             dt_autoexportpath        varchar(250),
             dt_external_dms_dokutype varchar(100),
             dt_display_limit         integer,
             dt_parentnodeid_default  boolean,
             insert_date              date,
             insert_by                varchar(32),
             modified_date            timestamp(0),
             modified_by              varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__DokSealSQL(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO DokSealSQL (
                             dss_id,
                             dss_stamp,
                             dss_bez,
                             dss_dt_id,
                             dss_pd_id,
                             dss_deletesql,
                             dss_insertsql,
                             dss_txt,
                             insert_date,
                             insert_by,
                             modified_date,
                             modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      dss_id,
                      dss_stamp,
                      dss_bez,
                      dss_dt_id,
                      dss_pd_id,
                      dss_deletesql,
                      dss_insertsql,
                      dss_txt,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM DokSealSQL
                  ')
        AS (
             dss_id                integer,
             dss_stamp             timestamp(0),
             dss_bez               varchar(50),
             dss_dt_id             varchar(30),
             dss_pd_id             integer,
             dss_deletesql         text,
             dss_insertsql         text,
             dss_txt               text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__RecnoCommentKategorie(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO RecnoCommentKategorie(
                      rck_id,
                      rck_schema,
                      rck_modified,
                      rck_b,
                      rck_gruppe,
                      rck_column,
                      rck_mapto,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      rck_id,
                      rck_schema,
                      rck_modified,
                      rck_b,
                      rck_gruppe,
                      rck_column,
                      rck_mapto,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM RecnoCommentKategorie
                  ')
        AS (
             rck_id                varchar(30),
             rck_schema            varchar(50),
             rck_modified          timestamp(0),
             rck_b_                varchar(30),
             rck_gruppe            varchar(20),
             rck_column            varchar(20),
             rck_mapto             varchar(30),
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           )
    WHERE NOT EXISTS( SELECT true FROM RecnoCommentKategorie WHERE rck_b = rck_b_ );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__reports(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO reports (
                          r_id,
                          r_modulname,
                          r_grouptxt,
                          r_stamp,
                          r_modified,
                          r_descr,
                          r_sql,
                          r_minver,
                          r_blob,
                          r_hlpcontxt,
                          r_beforescript,
                          r_wherertf,
                          r_afterrtf,
                          r_afterscript,
                          r_dual,
                          r_detail,
                          r_pos,
                          r_kunde,
                          r_inheritfrom,
                          r_reportparameter,
                          r_reportgen,
                          r_deleted,
                          r_localmodified,
                          r_changetext,
                          r_visible,
                          r_dokutype,
                          r_shorthlptxtnr,
                          insert_date,
                          insert_by,
                          modified_date,
                          modified_by
                    )
    SELECT                r_id,
                          r_modulname,
                          r_grouptxt,
                          r_stamp,
                          r_modified,
                          r_descr,
                          r_sql,
                          r_minver,
                          lo_from_bytea( 0, r_blob ) AS r_blob,   --- bytea -> lo
                          r_hlpcontxt,
                          r_beforescript,
                          r_wherertf,
                          r_afterrtf,
                          r_afterscript,
                          r_dual,
                          r_detail,
                          r_pos,
                          r_kunde,
                          r_inheritfrom,
                          r_reportparameter,
                          r_reportgen,
                          r_deleted,
                          r_localmodified,
                          r_changetext,
                          r_visible,
                          r_dokutype,
                          r_shorthlptxtnr,
                          insert_date,
                          insert_by,
                          modified_date,
                          modified_by
      FROM dblink(_dblink,
                   'SELECT
                      r_id,
                      r_modulname,
                      r_grouptxt,
                      r_stamp,
                      r_modified,
                      r_descr,
                      r_sql,
                      r_minver,
                      lo_get( r_blob ) AS r_blob,   --- lo -> bytea
                      r_hlpcontxt,
                      r_beforescript,
                      r_wherertf,
                      r_afterrtf,
                      r_afterscript,
                      r_dual,
                      r_detail,
                      r_pos,
                      r_kunde,
                      r_inheritfrom,
                      r_reportparameter,
                      r_reportgen,
                      r_deleted,
                      r_localmodified,
                      r_changetext,
                      r_visible,
                      r_dokutype,
                      r_shorthlptxtnr,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM reports
                  ')
        AS (
             r_id                  integer,
             r_modulname           varchar(50),
             r_grouptxt            integer,
             r_stamp               timestamp(0),
             r_modified            timestamp(0),
             r_descr               integer,
             r_sql                 text,
             r_minver              varchar(11),
             r_blob                bytea,
             r_hlpcontxt           varchar,
             r_beforescript        text,
             r_wherertf            integer,
             r_afterrtf            integer,
             r_afterscript         text,
             r_dual                boolean,
             r_detail              varchar(75),
             r_pos                 integer,
             r_kunde               varchar(50),
             r_inheritfrom         timestamp(0),
             r_reportparameter     text,
             r_reportgen           varchar(5),
             r_deleted             boolean,
             r_localmodified       boolean,
             r_changetext          text,
             r_visible             boolean,
             r_dokutype            varchar(30),
             r_shorthlptxtnr       integer,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__report_links(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO report_links (
                           rl_id,
                           rl_stamp,
                           rl_modified,
                           rl_r_stamp,
                           rl_modulname,
                           rl_pos,
                           rl_customTxtNo,
                           rl_customDetail,
                           rl_customSql,
                           rl_customParams,
                           insert_date,
                           insert_by,
                           modified_date,
                           modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      rl_id,
                      rl_stamp,
                      rl_modified,
                      rl_r_stamp,
                      rl_modulname,
                      rl_pos,
                      rl_customTxtNo,
                      rl_customDetail,
                      rl_customSql,
                      rl_customParams,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM report_links
                  ')
        AS (
             rl_id                 integer,
             rl_stamp              timestamp(0),
             rl_modified           timestamp(0),
             rl_r_stamp            timestamp(0),
             rl_modulname          varchar(75),
             rl_pos                integer,
             rl_customTxtNo        integer,
             rl_customDetail       varchar(100),
             rl_customSql          text,
             rl_customParams       text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION tsystem.syncro__report_datasets(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO report_datasets (
                      rds_id,
                      rds_r_id,
                      rds_pos,
                      rds_name,
                      rds_master,
                      rds_descr,
                      rds_sql,
                      rds_deact,
                      rds_linkfield,
                      rds_masterfield,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      rds_id,
                      rds_r_id,
                      rds_pos,
                      rds_name,
                      rds_master,
                      rds_descr,
                      rds_sql,
                      rds_deact,
                      rds_linkfield,
                      rds_masterfield,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM report_datasets
                  ')
        AS (
             rds_id                integer,
             rds_r_id              integer,
             rds_pos               integer,
             rds_name              varchar(10),
             rds_master            varchar(10),
             rds_descr             varchar(50),
             rds_sql               TEXT,
             rds_deact             BOOL,
             rds_linkfield         varchar,
             rds_masterfield       varchar,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__report_translations(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO report_translations (
                      rt_r_id,
                      rt_varname,
                      rt_spco,
                      rt_text,
                      rt_kundtext,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      rt_r_id,
                      rt_varname,
                      rt_spco,
                      rt_text,
                      rt_kundtext,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM report_translations
                  ')
        AS (
             rt_r_id               integer,
             rt_varname            varchar(80),
             rt_spco               smallint,
             rt_text               text,
             rt_kundtext           text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__SettingsDyn(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

  ALTER TABLE SettingsDyn DISABLE TRIGGER settingsdyn_set_modified;

    INSERT INTO SettingsDyn (
                            sd_id,
                            sd_name,
                            sd_parentid,
                            sd_type,
                            sd_sort,
                            sd_config,
                            sd_settingsname,
                            sd_settingstype,
                            sd_vartxtnr,
                            sd_deleted,
                            insert_date,
                            insert_by,
                            modified_date,
                            modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      sd_id,
                      sd_name,
                      sd_parentid,
                      sd_type,
                      sd_sort,
                      sd_config,
                      sd_settingsname,
                      sd_settingstype,
                      sd_vartxtnr,
                      sd_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM SettingsDyn
                  ')
        AS (
             sd_id                 integer,
             sd_name               varchar,
             sd_parentid           integer,
             sd_type               varchar(20),
             sd_sort               numeric(7, 2),
             sd_config             text,
             sd_settingsname       varchar(80),
             sd_settingstype       varchar(20),
             sd_vartxtnr           integer,
             sd_deleted            boolean,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );

    ALTER TABLE SettingsDyn ENABLE TRIGGER settingsdyn_set_modified;

  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__edi(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO edi (
                      edi_name,
                      edi_comments,
                      edi_sql_statement,
                      edi_text,
                      edi_ds_ssign,
                      edi_ds_header,
                      edi_rowseparator,
                      edi_UTF8ToAnsi,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      edi_name,
                      edi_comments,
                      edi_sql_statement,
                      edi_text,
                      edi_ds_ssign,
                      edi_ds_header,
                      edi_rowseparator,
                      edi_UTF8ToAnsi,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM edi
                  ')
        AS (
             edi_name_             varchar(50),
             edi_comments          text,
             edi_sql_statement     text,
             edi_text              text,
             edi_ds_ssign          varchar(30),
             edi_ds_header         varchar(30),
             edi_rowseparator      varchar(10),
             edi_UTF8ToAnsi        boolean,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           )
       WHERE NOT EXISTS( SELECT true FROM edi WHERE edi_name = edi_name_ );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__doSqluserselect(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO doSqluserselect (
                      sus_id,
                      sus_modified,
                      sus_name,
                      sus_sql,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      sus_id,
                      sus_modified,
                      sus_name,
                      sus_sql,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM doSqluserselect
                  ')
        AS (
             sus_id                timestamp(0),
             sus_modified          timestamp(0),
             sus_name              integer,
             sus_sql               text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__systemsqlstatement(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO systemsqlstatement (
                      sql_stamp,
                      sql_modified,
                      sql_name,
                      sql_descr,
                      sql_sql,
                      sql_sqlselect,
                      sql_macro,
                      sql_minver,
                      sql_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      sql_stamp,
                      sql_modified,
                      sql_name,
                      sql_descr,
                      sql_sql,
                      sql_sqlselect,
                      sql_macro,
                      sql_minver,
                      sql_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM systemsqlstatement
                  ')
        AS (
             sql_stamp              timestamp(0),
             sql_modified           timestamp(0),
             sql_name               varchar(100),
             sql_descr              text,
             sql_sql                text,
             sql_sqlselect          text,
             sql_macro              text,
             sql_minver             varchar(11),
             sql_deleted            boolean,
             insert_date            date,
             insert_by              varchar(32),
             modified_date          timestamp(0),
             modified_by            varchar(32)
           );

    ---
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__olapbisettings(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO olapbisettings (
                      obi_stamp,
                      obi_modified,
                      obi_id,
                      obi_name,
                      obi_default,
                      obi_pos,
                      obi_bez,
                      obi_txt,
                      obi_all,
                      obi_system_sync,
                      obi_data,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT            obi_stamp,
                      obi_modified,
                      obi_id,
                      obi_name,
                      obi_default,
                      obi_pos,
                      obi_bez,
                      obi_txt,
                      obi_all,
                      obi_system_sync,
                      lo_from_bytea( 0, obi_data ) AS obi_data,   --- bytea -> lo
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
      FROM dblink(_dblink,
                   'SELECT
                      obi_stamp,
                      obi_modified,
                      obi_id,
                      obi_name,
                      obi_default,
                      obi_pos,
                      obi_bez,
                      obi_txt,
                      obi_all,
                      obi_system_sync,
                      lo_get( obi_data ) AS obi_data,   --- lo -> bytea
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM olapbisettings
                  ')
        AS (
             obi_stamp             timestamp(0),
             obi_modified          timestamp(0),
             obi_id                integer,
             obi_name              varchar(50),
             obi_default           boolean,
             obi_pos               integer,
             obi_bez               varchar(100),
             obi_txt               text,                           -- Beschreibung
             obi_all               boolean,
             obi_system_sync       boolean,
             obi_data              bytea,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__component_options(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO component_options (
                      co_id,
                      co_item,
                      co_minr,
                      co_name,
                      co_value,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      co_id,
                      co_item,
                      co_minr,
                      co_name,
                      co_value,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM component_options
                  ')
        AS (
             co_id                 integer,
             co_item               integer,
             co_minr               integer,
             co_name               varchar(100),
             co_value              text,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__gridlayout(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO gridlayout (
                      gl_id,
                      gl_item,
                      gl_minr,
                      gl_detailview,
                      gl_layout,
                      gl_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      gl_id,
                      gl_item,
                      gl_minr,
                      gl_detailview,
                      gl_layout,
                      gl_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM gridlayout
                  ')
        AS (
             gl_id                 integer,
             gl_item               integer,
             gl_minr               integer,
             gl_detailview         varchar(50),
             gl_layout             bytea,
             gl_deleted            boolean,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__helpindex(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO helpindex (
                      hi_id,
                      hi_item,
                      hi_helplink,
                      hi_anker,
                      hi_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      hi_id,
                      hi_item,
                      hi_helplink,
                      hi_anker,
                      hi_deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM helpindex
                  ')
        AS (
             hi_id                 integer,
             hi_item               integer,
             hi_helplink           varchar(150),
             hi_anker              varchar(20),
             hi_deleted            boolean,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
            modified_by            varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__Keyboard_ShortCuts(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO Keyboard_ShortCuts (
                      kbsc_id,
                      kbsc_KeyCode,
                      kbsc_KeyState,
                      kbsc_KeyValue,
                      kbsc_Comment,
                      kbsc_Kunde,
                      kbsc_Deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      kbsc_id,
                      kbsc_KeyCode,
                      kbsc_KeyState,
                      kbsc_KeyValue,
                      kbsc_Comment,
                      kbsc_Kunde,
                      kbsc_Deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM Keyboard_ShortCuts
                  ')
        AS (
             kbsc_id               integer,
             kbsc_KeyCode          integer,
             kbsc_KeyState         integer,
             kbsc_KeyValue         varchar(20),
             kbsc_Comment          text,
             kbsc_Kunde            varchar(20),
             kbsc_Deleted          bool,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

---
CREATE OR REPLACE FUNCTION tsystem.syncro__Keyboard_Layouts(IN _dblink varchar DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$

  BEGIN

    SET LOCAL SESSION AUTHORIZATION syncro;

    INSERT INTO Keyboard_Layouts (
                      kblay_id,
                      kblay_Name,
                      kblay_Data,
                      kblay_Kunde,
                      kblay_Deleted,
                  insert_date,
            insert_by,
            modified_date,
            modified_by
                    )
    SELECT *
      FROM dblink(_dblink,
                   'SELECT
                      kblay_id,
                      kblay_Name,
                      kblay_Data,
                      kblay_Kunde,
                      kblay_Deleted,
                      insert_date,
                      insert_by,
                      modified_date,
                      modified_by
                    FROM Keyboard_Layouts
                  ')
        AS (
             kblay_id              integer,
             kblay_Name            varchar(100),
             kblay_Data            text,
             kblay_Kunde           varchar(20),
             kblay_Deleted         bool,
             insert_date           date,
             insert_by             varchar(32),
             modified_date         timestamp(0),
             modified_by           varchar(32)
           );
  END $$ LANGUAGE plpgsql;

------------------------------
CREATE OR REPLACE FUNCTION tsystem.syncro__all(IN _dblink VARCHAR DEFAULT 'host=pg.prodat-erp.de port=5432 dbname=PRODAT-18.08 user=syncro password=syncro') RETURNS void AS $$
 BEGIN
    ---  Tabellen leeren
    DELETE FROM doSqluserselect;

    DELETE FROM text0;
    DELETE FROM dbupdates;

    ALTER TABLE f2poss DISABLE RULE f2poss_delete;
    DELETE FROM f2poss;
    ALTER TABLE f2poss ENABLE RULE f2poss_delete;

    DELETE FROM f2rck;
    DELETE FROM fieldalias;
    DELETE FROM itemlist;
    DELETE FROM gridfilter;

    DELETE FROM f2standard;
    DELETE FROM mainmenu;
    DELETE FROM sondfunc;
    DELETE FROM picndoku;
    DELETE FROM DokSealSQL;

    DELETE FROM recnokeyword;
    DELETE FROM RecnoCommentKategorie;
    INSERT INTO recnocommentkategorie(rck_id, rck_b, rck_gruppe)
      VALUES ('internal system usage', 'Interne Verwendung', 'System');

    DELETE FROM report_translations;
    DELETE FROM report_datasets;
    DELETE FROM report_links;
    DELETE FROM report_afterrep;

    ALTER TABLE reports DISABLE RULE reports_delete;
    DELETE FROM reports;
    ALTER TABLE reports ENABLE RULE reports_delete;

    DELETE FROM dokutypes;
    DELETE FROM runtimeforms;

    ALTER TABLE SettingsDyn DISABLE RULE SettingsDyn_delete;
    DELETE FROM SettingsDyn;
    ALTER TABLE SettingsDyn ENABLE RULE SettingsDyn_delete;

    DELETE FROM systemsqlstatement;
    DELETE FROM olapbisettings;
    DELETE FROM component_options;
    DELETE FROM gridlayout;
    DELETE FROM helpindex;
    DELETE FROM Keyboard_ShortCuts;
    DELETE FROM Keyboard_Layouts;
    ---
    PERFORM tsystem.syncro__text0                  (_dblink);
    PERFORM tsystem.syncro__dbupdates              (_dblink);
    PERFORM tsystem.syncro__runtimeforms           (_dblink);
    PERFORM tsystem.syncro__f2standard             (_dblink);
    PERFORM tsystem.syncro__f2poss__f2rck          (_dblink);
    PERFORM tsystem.syncro__fieldalias             (_dblink);
    PERFORM tsystem.syncro__itemlist               (_dblink);
    PERFORM tsystem.syncro__gridfilter             (_dblink);
    ---
    PERFORM tsystem.syncro__mainmenu               (_dblink);
    PERFORM tsystem.syncro__runtimeforms           (_dblink);
    PERFORM tsystem.syncro__sondfunc               (_dblink);
    PERFORM tsystem.syncro__picndoku               (_dblink);
    PERFORM tsystem.syncro__dokutypes              (_dblink);
    PERFORM tsystem.syncro__DokSealSQL             (_dblink);
    PERFORM tsystem.syncro__RecnoCommentKategorie  (_dblink);
    PERFORM tsystem.syncro__reports                (_dblink);
    PERFORM tsystem.syncro__report_datasets        (_dblink);
    PERFORM tsystem.syncro__report_links           (_dblink);
    PERFORM tsystem.syncro__report_translations    (_dblink);
    PERFORM tsystem.syncro__SettingsDyn            (_dblink);
    PERFORM tsystem.syncro__edi                    (_dblink);
    PERFORM tsystem.syncro__doSqluserselect        (_dblink);
    PERFORM tsystem.syncro__systemsqlstatement     (_dblink);
    PERFORM tsystem.syncro__olapbisettings         (_dblink);
    PERFORM tsystem.syncro__component_options      (_dblink);
    PERFORM tsystem.syncro__gridlayout             (_dblink);
    PERFORM tsystem.syncro__helpindex              (_dblink);
    PERFORM tsystem.syncro__Keyboard_ShortCuts     (_dblink);
    PERFORM tsystem.syncro__Keyboard_Layouts       (_dblink);

  END $$ LANGUAGE plpgsql;
---
--- Synchronisation durchführen
SELECT syncro__all();
